#!/usr/local/bin/ruby

#############################
#
# Uses packages:
#   JSON (gem install JSON)
#
# Requires application:
#     openssl (for converting keys from PKCS8 to PKCS1)
#
# Usage:
#     Download API key from https://app.aplos.com/aws/settings/api/configure
#     This should result in a file with the name (aplos_id.key).
#     Put that file in the same directory as this ruby script, adding the extension:
#     .download, so your new file name will be (aplos_id.key.download).
#     Update the api_id value with your api_key value.
#
#####

require 'net/http'
require 'uri'
require 'json'
require 'openssl'
require 'base64'
require 'open3'

# Lets do some setup here...
# production
api_base_url = 'https://app.aplos.com/hermes/api/v1/'
api_id = '[YOUR API KEY HERE]'


# Convert PKCS8 to pkcs1
def convert_pkcs8_to_pkcs1(api_id)
  api_user_pkcs8file = ''
  api_user_pemkey = ''
  t = ''
  openssl_cvrt_cmd = ''
  IO.foreach(api_id + '.key.download') do |pkcs8file|
    b64 = Base64.encode64(Base64.decode64(pkcs8file))
    api_user_pkcs8file = "-----BEGIN PRIVATE KEY-----\n" << b64 << "-----END PRIVATE KEY-----\n"
  end
  IO.write(api_id + '.pkcs8', api_user_pkcs8file, 0)

  Open3.popen3('openssl version') do |_stdin, stdout, _stderr|
    t = stdout.read
  end

  if t == '0.9.8'
    openssl_cvrt_cmd = 'openssl pkcs8 -nocrypt -in ' + api_id + '.pkcs8 -out ' + api_id + '.key'
  else
    openssl_cvrt_cmd = 'openssl rsa -in ' + api_id + '.pkcs8 -outform PEM -out ' + api_id + '.key'
  end
  puts 'trying '
  puts openssl_cvrt_cmd
  system(openssl_cvrt_cmd)
  puts 'ended'
  puts openssl_cvrt_cmd

  IO.foreach(api_id + '.key') { |api_user_pemkey| }
  api_user_pemkey
end

def api_error_handling(status_code)
  if status_code == '200'
    puts 'Status: ' + status_code + ': The API let me in!'
    return
  elsif status_code == '401'
    puts 'Status: ' + status_code + ': Something is wrong with the auth code. Exiting'
    exit
  elsif status_code == '403'
    puts 'Status: ' + status_code + ': Forbidden. Exiting'
    exit
  elsif status_code == '405'
    puts 'Status: ' + status_code + ': Method not allowed. Exiting'
    exit
  elsif status_code == '422'
    puts 'Status: ' + status_code + ': Unprocessable Entity. Exiting'
    exit
  else
    puts 'Status: ' + status_code + ': Problem with the request. Exiting.'
    exit
  end
end

# Get auth info
def api_auth(api_base_url, api_id, api_user_key)
  # This should return an authorized token so we can do other, more exciting things
  # Lets show what we're doing.

  endpoint = 'auth/'
  puts 'geting URL: ' + api_base_url + endpoint + api_id

  uri = URI.parse(api_base_url + endpoint + api_id)
  request = Net::HTTP::Get.new(uri)

  http = Net::HTTP.new(uri.host, uri.port)
  http.use_ssl = true  # enable SSL/TLS
  http.verify_mode = OpenSSL::SSL::VERIFY_NONE  # you can check SSL certificates if needed

  r = http.start do |h|
    h.request(request)
  end
  puts r.body if r.is_a?(Net::HTTPSuccess)

  # Actual request goes here.

  data = JSON.parse(r.body)
  api_error_handling(r.code)
  api_token_encrypted = data['data']['token']
  api_token_encrypted_expires = data['data']['expires']

  puts 'The API Token expires: ' + api_token_encrypted_expires

  api_bearer_token = api_user_key.private_decrypt(Base64.decode64(api_token_encrypted))
  api_bearer_token
end

def api_contacts_get(api_base_url, _api_id, api_access_token)
  # This should print a contact from Aplos.
  # Lets show what we're doing.
  bearer_token = 'Bearer: ' + api_access_token
  endpoint = 'contacts'
  puts 'geting URL: ' + api_base_url + endpoint
  puts 'With bearer_token: ' + bearer_token

  # Actual request goes here.
  uri = URI.parse(api_base_url + endpoint)
  request = Net::HTTP::Get.new(uri)
  request.add_field('Authorization', bearer_token)

  http = Net::HTTP.new(uri.host, uri.port)
  http.use_ssl = true  # enable SSL/TLS
  http.verify_mode = OpenSSL::SSL::VERIFY_NONE  # you can check SSL certificates if needed

  r = http.start do |h|
    h.request(request)
  end

  puts r.body if r.is_a?(Net::HTTPSuccess)
  api_error_handling(r.code)
  data = JSON.parse(r.body)
  data
end

def api_accounts_get(api_base_url, _api_id, api_access_token)
  # This should print a contact from Aplos.
  # Lets show what we're doing.
  bearer_token = 'Bearer: ' + api_access_token
  endpoint = 'accounts'
  puts 'geting URL: ' + api_base_url + endpoint
  puts 'With bearer_token: ' + bearer_token

  # Actual request goes here.
  uri = URI.parse(api_base_url + endpoint)
  request = Net::HTTP::Get.new(uri)
  request.add_field('Authorization', bearer_token)

  http = Net::HTTP.new(uri.host, uri.port)
  http.use_ssl = true  # enable SSL/TLS
  http.verify_mode = OpenSSL::SSL::VERIFY_NONE  # you can check SSL certificates if needed

  r = http.start do |h|
    h.request(request)
  end

  puts r.body if r.is_a?(Net::HTTPSuccess)
  api_error_handling(r.code)
  data = JSON.parse(r.body)
  data
end

def api_transactions_get(api_base_url, _api_id, api_access_token)
  # This should print a contact from Aplos.
  # Lets show what we're doing.
  bearer_token = 'Bearer: ' + api_access_token
  endpoint = 'transactions'
  puts 'geting URL: ' + api_base_url + endpoint
  puts 'With bearer_token: ' + bearer_token

  # Actual request goes here.
  uri = URI.parse(api_base_url + endpoint)
  request = Net::HTTP::Get.new(uri)
  request.add_field('Authorization', bearer_token)

  http = Net::HTTP.new(uri.host, uri.port)
  http.use_ssl = true  # enable SSL/TLS
  http.verify_mode = OpenSSL::SSL::VERIFY_NONE  # you can check SSL certificates if needed

  r = http.start do |h|
    h.request(request)
  end

  puts r.body if r.is_a?(Net::HTTPSuccess)
  api_error_handling(r.code)
  data = JSON.parse(r.body)
  data
end

def api_transactions_post(api_base_url, _api_id, api_access_token)
  # This should print a contact from Aplos.
  # Lets show what we're doing.
  bearer_token = 'Bearer: ' + api_access_token
  endpoint = 'transactions'
  puts 'Posting URL: ' + api_base_url + endpoint
  puts 'With bearer_token: ' + bearer_token
  # Actual request goes here.
  # Note, these values must match extant data so you need fund: 647 and
  # accounts, 1010 and 4002. If these aren't there, you will get a 422.

  payload = '{"note": "Insert a transaction", ' \
      '"date": "2015-06-01", ' \
      '"contact": { ' \
      '"companyname": "Aplos", ' \
      '"type": "company" }, ' \
      '"lines": [ { ' \
      '"amount": 123.45, ' \
      '"account": { ' \
      '"account_number": 1010 }, ' \
      '"fund": { ' \
      '"id": 647 } }, ' \
      '{ ' \
      '"amount": -123.45, ' \
      '"account": { ' \
      '"account_number": 4002 }, ' \
      '"fund": { ' \
      '"id": 647 ' \
      '} } ] }'
  print payload
  uri = URI.parse(api_base_url + endpoint)
  request = Net::HTTP::Post.new(uri)
  request.add_field('Authorization', bearer_token)
  request.content_type = 'application/json'
  request.body = payload

  http = Net::HTTP.new(uri.host, uri.port)
  http.use_ssl = true  # enable SSL/TLS
  http.verify_mode = OpenSSL::SSL::VERIFY_NONE  # you can check SSL certificates if needed

  r = http.start do |h|
    h.request(request)
  end

  puts r.body if r.is_a?(Net::HTTPSuccess)
  api_error_handling(r.code)
  data = JSON.parse(r.body)
  data
end

api_user_pemkey = ''
if File.file?(api_id + '.key')
  puts 'Key file exists.'
  IO.foreach(api_id + '.key') { |pkeyfile| api_user_pemkey = pkeyfile }
else
  puts 'Key file is empty.'
  convert_pkcs8_to_pkcs1(api_id)
  IO.foreach(api_id + '.key') { |pkeyfile| api_user_pemkey = pkeyfile }
end

api_user_key = OpenSSL::PKey::RSA.new(File.read(api_id + '.key'))
api_access_token = api_auth(api_base_url, api_id, api_user_key)
puts api_access_token

api_contacts_get(api_base_url, api_id, api_access_token)
api_accounts_get(api_base_url, api_id, api_access_token)
api_transactions_get(api_base_url, api_id, api_access_token)
api_transactions_post(api_base_url, api_id, api_access_token)

puts "Now we're done."
